/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.server.command;

import com.google.common.primitives.Ints;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;

public class CommandSetBiome
implements ICommand {
    private final List<String> aliases = Arrays.asList("btsetbiome", "biometweakersetbiome", "bts", "biometweakers");

    public int compareTo(ICommand c) {
        return this.func_71517_b().compareTo(c.func_71517_b());
    }

    public String func_71517_b() {
        return "BTSetBiome";
    }

    public String func_71518_a(ICommandSender p_71518_1_) {
        return "biometweaker.msg.setbiome.usage.text";
    }

    public List func_71514_a() {
        return this.aliases;
    }

    public boolean func_82358_a(String[] p_82358_1_, int p_82358_2_) {
        return false;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        BlockPos coord = sender.func_180425_c();
        World world = sender.func_130014_f_();
        if (coord != null && world != null) {
            if (args.length < 2 || args.length > 3) {
                sender.func_145747_a(new TextComponentTranslation("biometweaker.msg.setbiome.invalargs.text", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                return;
            }
            Biome gen = null;
            Integer i = Ints.tryParse((String)args[0]);
            if (i != null) {
                gen = Biome.func_150568_d((int)i);
            } else {
                for (Biome biome : Biome.field_185377_q) {
                    if (biome == null || !biome.func_185359_l().equals(args[0])) continue;
                    gen = biome;
                    break;
                }
            }
            if (gen == null) {
                sender.func_145747_a(new TextComponentTranslation("biometweaker.msg.setbiome.invalargs.text", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                return;
            }
            int id = Biome.func_185362_a((Biome)gen);
            i = Ints.tryParse((String)args[1]);
            if (i == null) {
                sender.func_145747_a(new TextComponentTranslation("biometweaker.msg.setbiome.invalargs.text", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                return;
            }
            boolean blocks = true;
            if (args.length == 3) {
                if (args[2].equalsIgnoreCase("block")) {
                    blocks = true;
                } else if (args[2].equalsIgnoreCase("chunk")) {
                    blocks = false;
                } else {
                    sender.func_145747_a(new TextComponentTranslation("biometweaker.msg.setbiome.invalargs.text", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                    return;
                }
            }
            int count = 0;
            if (blocks) {
                for (int x = coord.func_177958_n() - i; x <= coord.func_177958_n() + i; ++x) {
                    for (int z = coord.func_177952_p() - i; z <= coord.func_177952_p() + i; ++z) {
                        int realX = x & 0xF;
                        int realZ = z & 0xF;
                        Chunk chunk = world.func_175726_f(new BlockPos(x, 0, z));
                        chunk.func_76605_m()[realZ * 16 + realX] = (byte)id;
                        chunk.func_76630_e();
                        ++count;
                    }
                }
                sender.func_145747_a(new TextComponentTranslation("biometweaker.msg.setbiome.blocksuccess.text", new Object[]{count, gen.func_185359_l()}).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD)));
            } else {
                byte[] biomeArray = new byte[256];
                Arrays.fill(biomeArray, (byte)id);
                int chunkX = coord.func_177958_n() >> 4;
                int chunkZ = coord.func_177952_p() >> 4;
                for (int x = chunkX - i; x <= chunkX + i; ++x) {
                    for (int z = chunkZ - i; z <= chunkZ + i; ++z) {
                        Chunk chunk = world.func_72964_e(x, z);
                        chunk.func_76616_a(Arrays.copyOf(biomeArray, biomeArray.length));
                        chunk.func_76630_e();
                        ++count;
                    }
                }
                sender.func_145747_a(new TextComponentTranslation("biometweaker.msg.setbiome.chunksuccess.text", new Object[]{count, gen.func_185359_l()}).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD)));
            }
        } else {
            sender.func_145747_a(new TextComponentTranslation("biometweaker.msg.info.invalsender.text", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
        }
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return sender.func_70003_b(server.func_110455_j(), this.func_71517_b());
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        return null;
    }
}

