/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.api.biometweaker.script.pack;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import me.superckl.api.biometweaker.script.pack.IBiomePackage;
import me.superckl.api.superscript.util.CollectionHelper;
import net.minecraft.world.biome.Biome;

public class IntersectBiomesPackage
implements IBiomePackage {
    List<IBiomePackage> packs = Lists.newArrayList();

    public IntersectBiomesPackage(IBiomePackage ... packs) {
        Collections.addAll(this.packs, packs);
    }

    @Override
    public Iterator<Biome> getIterator() {
        if (this.packs.size() == 0) {
            return Iterators.emptyIterator();
        }
        List[] lists = new List[this.packs.size()];
        for (int i = 0; i < this.packs.size(); ++i) {
            ArrayList list = Lists.newArrayList();
            Iterators.addAll((Collection)list, this.packs.get(i).getIterator());
            lists[i] = list;
        }
        ArrayList intersect = Lists.newArrayList((Iterable)lists[0]);
        Iterator it = intersect.iterator();
        while (it.hasNext()) {
            if (CollectionHelper.allContains(it.next(), lists)) continue;
            it.remove();
        }
        return intersect.iterator();
    }

    @Override
    public boolean supportsEarlyRawIds() {
        for (IBiomePackage pack : this.packs) {
            if (pack.supportsEarlyRawIds()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<Integer> getRawIds() {
        if (this.packs.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        List[] ints = new List[this.packs.size()];
        for (int i = 0; i < this.packs.size(); ++i) {
            ints[i] = this.packs.get(i).getRawIds();
        }
        ArrayList intersect = Lists.newArrayList((Iterable)ints[0]);
        Iterator it = intersect.iterator();
        while (it.hasNext()) {
            if (CollectionHelper.allContains(it.next(), ints)) continue;
            it.remove();
        }
        return intersect;
    }
}

