/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.plugins.generic;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.ArrayList;
import java.util.List;
import net.darkhax.wawla.plugins.InfoProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class PluginEnchantmentDescription
extends InfoProvider {
    private static final KeyBinding keyBindSneak = Minecraft.func_71410_x().field_71474_y.field_74311_E;
    private static boolean enabled = true;
    private static boolean showOwner = true;

    @Override
    public void addItemInfo(List<String> info, ItemStack stack, boolean advanced, EntityPlayer entityPlayer) {
        if (enabled && stack.func_77973_b() instanceof ItemEnchantedBook) {
            if (GameSettings.func_100015_a((KeyBinding)keyBindSneak)) {
                ItemEnchantedBook item = (ItemEnchantedBook)stack.func_77973_b();
                List<Enchantment> enchants = this.getEnchantments(item, stack);
                for (Enchantment enchant : enchants) {
                    info.add(I18n.func_135052_a((String)"tooltip.wawla.enchdesc.name", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)enchant.func_77320_a(), (Object[])new Object[0]));
                    info.add(this.getDescription(enchant));
                    if (!showOwner) continue;
                    info.add(I18n.func_135052_a((String)"tooltip.wawla.enchdesc.addedby", (Object[])new Object[0]) + ": " + ChatFormatting.BLUE + PluginEnchantmentDescription.getModName(enchant));
                }
            } else {
                info.add(I18n.func_135052_a((String)"tooltip.wawla.enchdesc.activate", (Object[])new Object[]{ChatFormatting.LIGHT_PURPLE, keyBindSneak.getDisplayName(), ChatFormatting.GRAY}));
            }
        }
    }

    @Override
    public void syncConfig(Configuration config) {
        enabled = config.getBoolean("EnchantDescriptions", "generic_items", true, "Should the tooltip for enchanted books give descriptions of the enchantment?");
        showOwner = config.getBoolean("ShowEnchantmentSource", "generic_items", true, "Should the tooltip for enchanted books show the name of the mod that added them?");
    }

    private String getDescription(Enchantment enchantment) {
        String key = PluginEnchantmentDescription.getTranslationKey(enchantment);
        String description = I18n.func_135052_a((String)key, (Object[])new Object[0]);
        if (description.startsWith("enchantment.")) {
            description = I18n.func_135052_a((String)"tooltip.wawla.enchdesc.missing", (Object[])new Object[]{PluginEnchantmentDescription.getModName(enchantment), key});
        }
        return description;
    }

    private List<Enchantment> getEnchantments(ItemEnchantedBook book, ItemStack stack) {
        NBTTagList enchTags = book.func_92110_g(stack);
        ArrayList<Enchantment> enchantments = new ArrayList<Enchantment>();
        if (enchTags != null) {
            for (int index = 0; index < enchTags.func_74745_c(); ++index) {
                short id = enchTags.func_150305_b(index).func_74765_d("id");
                Enchantment enchant = Enchantment.func_185262_c((int)id);
                if (enchant == null) continue;
                enchantments.add(enchant);
            }
        }
        return enchantments;
    }

    public static String getModName(IForgeRegistryEntry.Impl<?> registerable) {
        String modID = registerable.getRegistryName().func_110624_b();
        ModContainer mod = (ModContainer)Loader.instance().getIndexedModList().get(modID);
        return mod != null ? mod.getName() : modID;
    }

    public static String getTranslationKey(Enchantment enchant) {
        return String.format("enchantment.%s.%s.desc", enchant.getRegistryName().func_110624_b(), enchant.getRegistryName().func_110623_a());
    }
}

