/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.plugins.generic;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.List;
import net.darkhax.wawla.lib.InfoAccess;
import net.darkhax.wawla.plugins.InfoProvider;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StringUtils;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;

public class PluginAnimal
extends InfoProvider {
    private static boolean enabled = true;
    private static boolean showBreedingCooldown = true;
    private static boolean showGrowingCooldown = true;
    private static boolean showBreedingItem = true;

    @Override
    public void addEntityInfo(List<String> info, InfoAccess data) {
        if (enabled && data.entity instanceof EntityAnimal) {
            EntityAnimal entity = (EntityAnimal)data.entity;
            int age = data.tag.func_74762_e("AnimalGrowingAge");
            if (age != 0) {
                if (showBreedingCooldown && age < 0) {
                    info.add(I18n.func_135052_a((String)"tooltip.wawla.generic.growingage", (Object[])new Object[0]) + ": " + StringUtils.func_76337_a((int)Math.abs(age)));
                }
                if (showGrowingCooldown && age > 0) {
                    info.add(I18n.func_135052_a((String)"tooltip.wawla.generic.breedingtime", (Object[])new Object[0]) + ": " + StringUtils.func_76337_a((int)age));
                }
            }
            if (showBreedingItem && data.player.func_184614_ca() != null && entity.func_70877_b(data.player.func_184614_ca())) {
                info.add(ChatFormatting.YELLOW + I18n.func_135052_a((String)"tooltip.wawla.generic.breedingitem", (Object[])new Object[0]));
            }
        }
    }

    @Override
    public void writeEntityNBT(World world, Entity entity, NBTTagCompound tag) {
        if (enabled && entity instanceof EntityAnimal) {
            EntityAnimal animal = (EntityAnimal)entity;
            if (showBreedingCooldown || showGrowingCooldown) {
                tag.func_74768_a("AnimalGrowingAge", animal.func_70874_b());
            }
        }
    }

    @Override
    public boolean requireEntitySync(World world, Entity entity) {
        return enabled && entity instanceof EntityAnimal;
    }

    @Override
    public void syncConfig(Configuration config) {
        enabled = config.getBoolean("Animal", "generic_entities", true, "When enabled, information about the animal will be displayed.");
        showBreedingCooldown = config.getBoolean("Animal_Breeding_Cooldown", "generic_entities", true, "When enabled, shows how long the entity has before it can breed again.");
        showGrowingCooldown = config.getBoolean("Animal_Growing_Age", "generic_entities", true, "When enabled, shows how long the entity has before it is fully grown.");
        showBreedingItem = config.getBoolean("Animal_Breeding_Item", "generic_entities", true, "When enabled, will show if the held item is a breeding item.");
    }
}

