/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.icse.common.packet;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.darkhax.icse.ICSE;
import net.darkhax.icse.common.packet.PacketSendInfo;
import net.darkhax.icse.plugins.InfoPlugin;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketRequestInfo
implements IMessage {
    public BlockPos pos;
    public UUID entityID;

    public PacketRequestInfo() {
    }

    public PacketRequestInfo(BlockPos pos) {
        this.pos = pos;
    }

    public PacketRequestInfo(UUID entityID) {
        this.entityID = entityID;
    }

    public void fromBytes(ByteBuf buf) {
        boolean isTileRequest = buf.readBoolean();
        if (isTileRequest) {
            this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        } else {
            this.entityID = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        boolean isTileRequest = this.pos != null;
        buf.writeBoolean(isTileRequest);
        if (isTileRequest) {
            buf.writeInt(this.pos.func_177958_n());
            buf.writeInt(this.pos.func_177956_o());
            buf.writeInt(this.pos.func_177952_p());
        } else {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.entityID.toString());
        }
    }

    public static class PacketHandler
    implements IMessageHandler<PacketRequestInfo, IMessage> {
        public IMessage onMessage(PacketRequestInfo packet, MessageContext ctx) {
            if (packet.pos != null) {
                this.syncTile(ctx.getServerHandler().field_147369_b, packet.pos);
            } else if (packet.entityID != null) {
                this.syncEntity(ctx.getServerHandler().field_147369_b, packet.entityID);
            }
            return null;
        }

        public void syncTile(EntityPlayerMP player, BlockPos pos) {
            World world = player.func_130014_f_();
            TileEntity tile = world.func_175625_s(pos);
            NBTTagCompound tag = new NBTTagCompound();
            if (tile != null) {
                for (InfoPlugin plugin : ICSE.plugins) {
                    if (!plugin.requireTileSync(world, tile)) continue;
                    plugin.writeTileNBT(world, tile, tag);
                }
            }
            ICSE.network.sendTo((IMessage)new PacketSendInfo(tag), player);
        }

        public void syncEntity(EntityPlayerMP player, UUID entityID) {
            World world = player.func_130014_f_();
            Entity entity = null;
            for (Entity loadedEntity : world.field_72996_f) {
                if (!loadedEntity.func_110124_au().equals(entityID)) continue;
                entity = loadedEntity;
            }
            NBTTagCompound tag = new NBTTagCompound();
            if (entity != null) {
                for (InfoPlugin plugin : ICSE.plugins) {
                    if (!plugin.requireEntitySync(world, entity)) continue;
                    plugin.writeEntityNBT(world, entity, tag);
                }
            }
            ICSE.network.sendTo((IMessage)new PacketSendInfo(tag), player);
        }
    }
}

