/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.component.lamp;

import com.amadornes.rscircuits.api.circuit.ICircuit;
import com.amadornes.rscircuits.api.component.EnumCircuitSide;
import com.amadornes.rscircuits.api.component.EnumCircuitUpdate;
import com.amadornes.rscircuits.api.component.EnumComponentSlot;
import com.amadornes.rscircuits.api.component.IComponent;
import com.amadornes.rscircuits.component.ComponentBaseInt;
import com.amadornes.rscircuits.component.ComponentButton;
import com.amadornes.rscircuits.component.SimpleFactory;
import com.amadornes.rscircuits.init.SCMItems;
import com.amadornes.rscircuits.item.EnumResourceType;
import java.util.Arrays;
import java.util.List;
import mcmultipart.MCMultiPartMod;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class ComponentLamp
extends ComponentButton {
    public static final ResourceLocation NAME = new ResourceLocation("rscircuits", "lamp");
    protected boolean state = false;

    public ComponentLamp(ICircuit circuit) {
        super(circuit, EnumComponentSlot.BOTTOM);
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }

    @Override
    public float getComplexity() {
        return 0.015f;
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public IBlockState getActualState() {
        return super.getActualState().func_177226_a(ON, (Comparable)Boolean.valueOf(this.state));
    }

    @Override
    public boolean isInput(EnumComponentSlot slot, EnumCircuitSide side) {
        return side != EnumCircuitSide.TOP;
    }

    @Override
    public void onAdded() {
        this.onNeighborChange(null, null, null, null);
    }

    @Override
    public void onNeighborChange(EnumCircuitSide side, EnumComponentSlot slot, IComponent component, EnumCircuitUpdate updateType) {
        if (side == EnumCircuitSide.BOTTOM && this.dropIfNeeded()) {
            return;
        }
        boolean prevState = this.state;
        boolean bl = this.state = this.getInput() != 0;
        if (this.state != prevState) {
            this.getCircuit().sendUpdate(this.getPos(), this.slot, false);
            this.getCircuit().markDirty();
        }
    }

    @Override
    public List<ItemStack> getDrops() {
        return Arrays.asList(this.getPickedItem());
    }

    @Override
    public ItemStack getPickedItem() {
        return new ItemStack(SCMItems.resource, 1, EnumResourceType.TINY_LAMP.ordinal());
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74757_a("state", this.state);
        return tag;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.state = tag.func_74767_n("state");
    }

    @Override
    public void writeDescription(PacketBuffer buf) {
        super.writeDescription(buf);
        buf.writeBoolean(this.state);
    }

    @Override
    public void readDescription(PacketBuffer buf) {
        super.readDescription(buf);
        this.state = buf.readBoolean();
    }

    public static class Factory
    extends SimpleFactory<ComponentLamp> {
        @Override
        public BlockStateContainer createBlockState() {
            return new BlockStateContainer((Block)MCMultiPartMod.multipart, new IProperty[]{ComponentBaseInt.ON});
        }

        @Override
        public ResourceLocation getModelPath() {
            return new ResourceLocation("rscircuits", "component/lamp");
        }

        @Override
        public boolean isValidPlacementStack(ItemStack stack, EntityPlayer player) {
            return stack.func_77973_b() == SCMItems.resource && stack.func_77952_i() == EnumResourceType.TINY_LAMP.ordinal();
        }

        @Override
        public ComponentLamp instantiate(ICircuit circuit) {
            return new ComponentLamp(circuit);
        }
    }
}

