/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.component.digital;

import com.amadornes.rscircuits.api.circuit.ICircuit;
import com.amadornes.rscircuits.api.component.EnumCircuitSide;
import com.amadornes.rscircuits.api.component.EnumCircuitUpdate;
import com.amadornes.rscircuits.api.component.EnumComponentSlot;
import com.amadornes.rscircuits.api.component.IComponent;
import com.amadornes.rscircuits.api.component.IComponentFactory;
import com.amadornes.rscircuits.component.ComponentBaseInt;
import com.amadornes.rscircuits.component.ComponentFace;
import com.amadornes.rscircuits.component.SimpleFactory;
import com.google.common.base.Function;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import mcmultipart.MCMultiPartMod;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class ComponentTorch
extends ComponentFace {
    public static final ResourceLocation NAME = new ResourceLocation("rscircuits", "torch");
    private boolean master;
    private boolean state = true;
    private boolean nextState = true;

    public ComponentTorch(ICircuit circuit, boolean master) {
        super(circuit, EnumComponentSlot.BOTTOM);
        this.master = master;
    }

    public ComponentTorch(ICircuit circuit) {
        super(circuit);
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }

    @Override
    public float getComplexity() {
        return 0.009f;
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public IBlockState getActualState() {
        return this.master ? super.getActualState().func_177226_a(ON, (Comparable)Boolean.valueOf(this.state)) : null;
    }

    @Override
    public float getSize() {
        return 0.625f;
    }

    @Override
    public Vec3d getOffset() {
        return new Vec3d(0.0, -0.3125, 0.0);
    }

    private boolean getState() {
        if (this.master) {
            return this.state;
        }
        ComponentTorch t = (ComponentTorch)this.getCircuit().getComponent(this.getPos().func_177977_b(), EnumComponentSlot.CENTER);
        return t != null ? t.state : false;
    }

    @Override
    public EnumSet<EnumComponentSlot> getSlots() {
        return this.master ? EnumSet.of(EnumComponentSlot.BOTTOM, EnumComponentSlot.CENTER, EnumComponentSlot.TOP) : EnumSet.of(EnumComponentSlot.BOTTOM, EnumComponentSlot.CENTER);
    }

    @Override
    public boolean isInput(EnumComponentSlot slot, EnumCircuitSide side) {
        return this.master && slot == this.slot;
    }

    @Override
    public boolean isOutput(EnumComponentSlot slot, EnumCircuitSide side) {
        return slot.side != side;
    }

    @Override
    public boolean isStrongOutput(EnumComponentSlot slot, EnumCircuitSide side) {
        return !this.master && slot == EnumComponentSlot.CENTER;
    }

    @Override
    public byte getOutputSignal(EnumComponentSlot slot, EnumCircuitSide side, EnumDyeColor color, boolean bundled) {
        return (byte)(this.getState() ? 255 : 0);
    }

    @Override
    public void onAdded() {
        this.onNeighborChange(EnumCircuitSide.BOTTOM, this.slot, this, EnumCircuitUpdate.COMPONENT_UPDATE);
        this.state = this.nextState;
    }

    @Override
    public void onScheduledTick(int type, Object data) {
        boolean prev = this.state;
        this.state = (Boolean)data;
        if (prev != this.state) {
            this.getCircuit().notifyUpdateAll(this.getPos(), EnumComponentSlot.CENTER);
            this.getCircuit().notifyUpdateAll(this.getPos().func_177984_a(), EnumComponentSlot.CENTER);
            this.getCircuit().sendUpdate(this.getPos(), this.slot, false);
            this.getCircuit().markDirty();
        }
    }

    @Override
    public void onNeighborChange(EnumCircuitSide side, EnumComponentSlot slot, IComponent component, EnumCircuitUpdate updateType) {
        IComponent c;
        if (!this.master) {
            return;
        }
        if (side == EnumCircuitSide.BOTTOM && !this.getCircuit().isSideSolid(this.getPos().func_177977_b(), EnumCircuitSide.TOP)) {
            this.getCircuit().removeComponent(this);
            this.getCircuit().removeComponent(this.getCircuit().getComponent(this.getPos().func_177984_a(), EnumComponentSlot.CENTER));
            this.getDrops().forEach(this.getCircuit()::spawnStack);
            return;
        }
        this.nextState = true;
        for (EnumCircuitSide s : EnumCircuitSide.HORIZONTALS) {
            if (this.getInputAny(EnumComponentSlot.BOTTOM, s) == 0) continue;
            this.nextState = false;
            break;
        }
        if (this.nextState && (c = this.getCircuit().getComponent(this.getPos().func_177977_b(), EnumComponentSlot.TOP)) != null && c.getOutputSignalAny(EnumComponentSlot.TOP, EnumCircuitSide.TOP) != 0) {
            this.nextState = false;
        }
        this.getCircuit().scheduleTick(this, 1, 0, this.nextState);
        this.getCircuit().markDirty();
    }

    @Override
    public boolean harvest(EntityPlayer player, Vec3d hitPos) {
        super.harvest(player, hitPos);
        this.getCircuit().removeComponent(this.getCircuit().getComponent(this.getPos().func_177984_a(), EnumComponentSlot.CENTER));
        return true;
    }

    @Override
    public void addSelectionBoxes(List<AxisAlignedBB> boxes) {
        double r = 0.3125;
        if (this.master) {
            boxes.add(new AxisAlignedBB(0.5 - r, 0.0, 0.5 - r, 0.5 + r, 1.5625, 0.5 + r));
        }
    }

    @Override
    public List<ItemStack> getDrops() {
        return this.master ? Arrays.asList(this.getPickedItem()) : Arrays.asList(new ItemStack[0]);
    }

    @Override
    public ItemStack getPickedItem() {
        return new ItemStack(Blocks.field_150429_aA);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74757_a("master", this.master);
        tag.func_74757_a("prevState", this.state);
        tag.func_74757_a("state", this.nextState);
        return tag;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.master = tag.func_74767_n("master");
        this.state = tag.func_74767_n("prevState");
        this.nextState = tag.func_74767_n("state");
    }

    @Override
    public void writeDescription(PacketBuffer buf) {
        super.writeDescription(buf);
        buf.writeBoolean(this.master);
        buf.writeBoolean(this.state);
        buf.writeBoolean(this.nextState);
    }

    @Override
    public void readDescription(PacketBuffer buf) {
        super.readDescription(buf);
        this.master = buf.readBoolean();
        this.state = buf.readBoolean();
        this.nextState = buf.readBoolean();
    }

    @Override
    public NBTTagCompound serializeTickData(int type, Object data) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("state", ((Boolean)data).booleanValue());
        return tag;
    }

    @Override
    public Object deserializeTickData(int type, NBTTagCompound tag) {
        return tag.func_74767_n("state");
    }

    public static class Factory
    implements IComponentFactory<Object> {
        private final Object object = new Object();

        @Override
        public BlockStateContainer createBlockState() {
            return new BlockStateContainer((Block)MCMultiPartMod.multipart, new IProperty[]{ComponentBaseInt.ON});
        }

        @Override
        public ResourceLocation getModelPath() {
            return new ResourceLocation("rscircuits", "component/torch");
        }

        @Override
        public boolean isValidPlacementStack(ItemStack stack, EntityPlayer player) {
            return stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150429_aA);
        }

        @Override
        public IComponentFactory.EnumPlacementType getPlacementType(ItemStack stack, EntityPlayer player) {
            return IComponentFactory.EnumPlacementType.SINGLE;
        }

        @Override
        public Object getPlacementData(ICircuit circuit, BlockPos pos, EnumCircuitSide faceClicked, Vec3d hitVec, ItemStack stack, EntityPlayer player, IComponentFactory.EnumPlacementType type, Object previousData, Map<BlockPos, Object> otherData, IComponentFactory.EnumInstantanceUse use) {
            if (previousData != null) {
                return previousData;
            }
            if (otherData.containsKey(pos.func_177977_b()) || otherData.containsKey(pos.func_177984_a())) {
                return null;
            }
            if (!circuit.isSideSolid(pos.func_177977_b(), EnumCircuitSide.TOP)) {
                return null;
            }
            return this.object;
        }

        @Override
        public boolean placeComponent(ICircuit circuit, BlockPos pos, Object data, IComponentFactory.EnumPlacementType type, Map<BlockPos, Object> otherData, boolean simulate) {
            ComponentTorch master = new ComponentTorch(circuit, true);
            ComponentTorch slave = new ComponentTorch(circuit, false);
            if (circuit.addComponent(pos, master, true) && circuit.addComponent(pos.func_177984_a(), slave, true)) {
                if (!simulate) {
                    circuit.addComponent(pos, master, false);
                    circuit.addComponent(pos.func_177984_a(), slave, false);
                }
                return true;
            }
            return false;
        }

        @Override
        public void drawPlacement(ICircuit circuit, BlockPos pos, Object data, IComponentFactory.EnumPlacementType type, Map<BlockPos, Object> otherData) {
            SimpleFactory.draw(data, o -> new ComponentTorch(circuit, true));
        }

        @Override
        public void serialize(PacketBuffer buf, Map<BlockPos, Object> data, EntityPlayer player) {
            buf.writeInt(data.size());
            data.forEach((pos, comp) -> buf.func_179255_a(pos));
        }

        @Override
        public void deserialize(PacketBuffer buf, Map<BlockPos, Object> data, Function<BlockPos, ICircuit> circuitProvider, EntityPlayer player) {
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                BlockPos pos = buf.func_179259_c();
                data.put(pos, this.object);
            }
        }

        @Override
        public IComponent instantiate(ICircuit circuit) {
            return new ComponentTorch(circuit);
        }
    }
}

