/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.api.component;

import com.amadornes.rscircuits.api.circuit.ICircuit;
import com.amadornes.rscircuits.api.component.EnumCircuitSide;
import com.amadornes.rscircuits.api.component.IComponent;
import com.google.common.base.Function;
import java.util.Map;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public interface IComponentFactory<T> {
    public BlockStateContainer createBlockState();

    public ResourceLocation getModelPath();

    public boolean isValidPlacementStack(ItemStack var1, EntityPlayer var2);

    public EnumPlacementType getPlacementType(ItemStack var1, EntityPlayer var2);

    public T getPlacementData(ICircuit var1, BlockPos var2, EnumCircuitSide var3, Vec3d var4, ItemStack var5, EntityPlayer var6, EnumPlacementType var7, T var8, Map<BlockPos, T> var9, EnumInstantanceUse var10);

    public boolean placeComponent(ICircuit var1, BlockPos var2, T var3, EnumPlacementType var4, Map<BlockPos, T> var5, boolean var6);

    public void drawPlacement(ICircuit var1, BlockPos var2, T var3, EnumPlacementType var4, Map<BlockPos, T> var5);

    public void serialize(PacketBuffer var1, Map<BlockPos, T> var2, EntityPlayer var3);

    public void deserialize(PacketBuffer var1, Map<BlockPos, T> var2, Function<BlockPos, ICircuit> var3, EntityPlayer var4);

    public IComponent instantiate(ICircuit var1);

    public static enum EnumInstantanceUse {
        PLACEMENT,
        RENDER;

    }

    public static enum EnumPlacementType {
        SINGLE,
        DRAW,
        LINE;

    }

    public static interface IDrawHandler<T>
    extends IComponentFactory<T> {
        public boolean finishDrawing(ICircuit var1, Map<BlockPos, T> var2, ItemStack var3, EntityPlayer var4);
    }

    public static interface IDrawListener<T>
    extends IComponentFactory<T> {
        public void onStartDrawing(EntityPlayer var1);

        public void onFinishDrawing(EntityPlayer var1);
    }
}

