/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.telepad.packet;

import com.enderio.core.common.network.MessageTileEntity;
import crazypants.enderio.EnderIO;
import crazypants.enderio.teleport.telepad.TileTelePad;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketTeleport
extends MessageTileEntity<TileEntity>
implements IMessageHandler<PacketTeleport, IMessage> {
    private int entityId;
    private String playerName;
    private Type type;
    private boolean wasBlocked;

    public PacketTeleport() {
    }

    public PacketTeleport(Type type, TileTelePad te, Entity entity) {
        super(te.getTileEntity());
        if (entity instanceof EntityPlayer) {
            EntityPlayer ep = (EntityPlayer)entity;
            this.playerName = ep.func_70005_c_();
            this.entityId = -1;
        } else {
            this.entityId = entity.func_145782_y();
            this.playerName = null;
        }
        this.type = type;
    }

    public PacketTeleport(Type type, TileTelePad te, boolean wasBlocked) {
        super(te.getTileEntity());
        this.wasBlocked = wasBlocked;
        this.type = type;
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.entityId);
        buf.writeInt(this.type.ordinal());
        buf.writeBoolean(this.wasBlocked);
        if (this.playerName != null) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.playerName);
        }
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.entityId = buf.readInt();
        this.type = Type.values()[buf.readInt()];
        this.wasBlocked = buf.readBoolean();
        if (this.entityId == -1) {
            this.playerName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
    }

    public IMessage onMessage(PacketTeleport message, MessageContext ctx) {
        World world = ctx.side.isClient() ? EnderIO.proxy.getClientWorld() : message.getWorld(ctx);
        TileEntity te = message.getTileEntity(world);
        if (te instanceof TileTelePad) {
            Object e = message.playerName != null ? world.func_72924_a(message.playerName) : world.func_73045_a(message.entityId);
            switch (message.type) {
                case BEGIN: {
                    ((TileTelePad)te).enqueueTeleport((Entity)e, false);
                    break;
                }
                case END: {
                    ((TileTelePad)te).dequeueTeleport((Entity)e, false);
                    break;
                }
                case TELEPORT: {
                    ((TileTelePad)te).setBlocked(message.wasBlocked);
                }
            }
        }
        return null;
    }

    public static enum Type {
        BEGIN,
        END,
        TELEPORT;

    }
}

