/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.render.property;

import crazypants.enderio.render.property.PropertyIO;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.util.EnumFacing;

public class IOMode
implements Comparable<IOMode> {
    private final EnumFacing direction;
    private final EnumIOMode iomode;
    private static final Map<String, IOMode> values = new HashMap<String, IOMode>();
    public static final PropertyIO IO = PropertyIO.getInstance();

    public static IOMode get(EnumFacing direction, EnumIOMode iomode) {
        String key = direction.toString().toLowerCase(Locale.US) + "_" + iomode.toString().toLowerCase(Locale.US);
        if (!values.containsKey(key)) {
            IOMode result = new IOMode(direction, iomode);
            values.put(key, result);
        }
        return values.get(key);
    }

    private IOMode(EnumFacing direction, EnumIOMode iomode) {
        this.direction = direction;
        this.iomode = iomode;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.direction == null ? 0 : this.direction.hashCode());
        result = 31 * result + (this.iomode == null ? 0 : this.iomode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IOMode other = (IOMode)obj;
        if (this.direction != other.direction) {
            return false;
        }
        return this.iomode == other.iomode;
    }

    @Override
    public int compareTo(IOMode o) {
        int d = this.direction.compareTo((Enum)o.direction);
        if (d != 0) {
            return d;
        }
        return this.iomode.ordinal() < o.iomode.ordinal() ? -1 : (this.iomode.ordinal() > o.iomode.ordinal() ? 1 : 0);
    }

    public String toString() {
        return this.direction.toString().toLowerCase(Locale.US) + "_" + this.iomode.toString().toLowerCase(Locale.US);
    }

    public static enum EnumIOMode {
        NONE,
        DISABLED,
        DISABLEDNOCENTER,
        DISABLEDSIDES,
        PULL,
        PULLSIDES,
        PULLTOPBOTTOM,
        PUSH,
        PUSHPULL,
        PUSHPULLSIDES,
        PUSHPULLTOPBOTTOM,
        PUSHSIDES,
        PUSHTOPBOTTOM,
        SELECTEDFACE,
        TRANSCIEVERDISABLED,
        TRANSCIEVERPULL,
        TRANSCIEVERPUSH,
        TRANSCIEVERPUSHPULL,
        CAPACITORBANK,
        CAPACITORBANKINPUT,
        CAPACITORBANKLOCKED,
        CAPACITORBANKOUTPUT,
        CAPACITORBANKINPUTSMALL,
        CAPACITORBANKLOCKEDSMALL,
        CAPACITORBANKOUTPUTSMALL,
        RESERVOIR;

    }
}

