/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.material;

import crazypants.enderio.ModObject;
import crazypants.enderio.material.Alloy;
import crazypants.enderio.material.MachinePart;
import crazypants.enderio.material.Material;
import crazypants.enderio.material.NutritiousStickRecipe;
import crazypants.enderio.material.PowderIngot;
import crazypants.enderio.material.fusedQuartz.FusedQuartzType;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class MaterialRecipes {
    public static void registerDependantOresInDictionary() {
        for (PowderIngot powder : PowderIngot.values()) {
            if (!powder.hasDependancy() || !powder.isDependancyMet()) continue;
            OreDictionary.registerOre((String)powder.oreDictName, (ItemStack)new ItemStack(ModObject.itemPowderIngot.getItem(), 1, powder.ordinal()));
            powder.setRegistered();
        }
    }

    public static void registerOresInDictionary() {
        for (PowderIngot powderIngot : PowderIngot.values()) {
            if (powderIngot.hasDependancy()) continue;
            OreDictionary.registerOre((String)powderIngot.oreDictName, (ItemStack)new ItemStack(ModObject.itemPowderIngot.getItem(), 1, powderIngot.ordinal()));
        }
        for (Enum enum_ : Alloy.values()) {
            for (String oreDictName : ((Alloy)enum_).getOreIngots()) {
                OreDictionary.registerOre((String)oreDictName, (ItemStack)((Alloy)enum_).getStackIngot());
            }
            for (String oreDictName : ((Alloy)enum_).getOreBlocks()) {
                OreDictionary.registerOre((String)oreDictName, (ItemStack)((Alloy)enum_).getStackBlock());
            }
        }
        OreDictionary.registerOre((String)"nuggetPulsatingIron", (ItemStack)new ItemStack(ModObject.itemMaterial.getItem(), 1, Material.PULSATING_IRON_NUGGET.ordinal()));
        OreDictionary.registerOre((String)"nuggetVibrantAlloy", (ItemStack)new ItemStack(ModObject.itemMaterial.getItem(), 1, Material.VIBRANT_NUGGET.ordinal()));
        ItemStack pureGlass = new ItemStack(ModObject.blockFusedQuartz.getBlock(), 1, FusedQuartzType.FUSED_GLASS.ordinal());
        OreDictionary.registerOre((String)"blockGlass", (ItemStack)pureGlass);
        OreDictionary.registerOre((String)"blockGlassColorless", (ItemStack)pureGlass);
        OreDictionary.registerOre((String)"blockGlassHardened", (ItemStack)new ItemStack(ModObject.blockFusedQuartz.getBlock(), 1, FusedQuartzType.FUSED_QUARTZ.ordinal()));
        OreDictionary.registerOre((String)"blockGlass", (ItemStack)new ItemStack(FusedQuartzType.FUSED_GLASS.getBlock(), 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"blockGlassHardened", (ItemStack)new ItemStack(FusedQuartzType.FUSED_QUARTZ.getBlock(), 1, Short.MAX_VALUE));
        String[] dyes = new String[]{"Black", "Red", "Green", "Brown", "Blue", "Purple", "Cyan", "LightGray", "Gray", "Pink", "Lime", "Yellow", "LightBlue", "Magenta", "Orange", "White"};
        for (int i = 0; i < 16; ++i) {
            OreDictionary.registerOre((String)("blockGlass" + dyes[i]), (ItemStack)new ItemStack(FusedQuartzType.FUSED_GLASS.getBlock(), 1, EnumDyeColor.func_176766_a((int)i).func_176765_a()));
            OreDictionary.registerOre((String)("blockGlassHardened" + dyes[i]), (ItemStack)new ItemStack(FusedQuartzType.FUSED_QUARTZ.getBlock(), 1, EnumDyeColor.func_176766_a((int)i).func_176765_a()));
        }
        for (FusedQuartzType type : FusedQuartzType.values()) {
            OreDictionary.registerOre((String)type.getUnlocalisedName(), (ItemStack)new ItemStack(ModObject.blockFusedQuartz.getBlock(), 1, type.ordinal()));
            OreDictionary.registerOre((String)type.getUnlocalisedName(), (ItemStack)new ItemStack(type.getBlock(), 1, Short.MAX_VALUE));
        }
        ItemStack skull = new ItemStack(Items.field_151144_bL, 1, Short.MAX_VALUE);
        OreDictionary.registerOre((String)"itemSkull", (ItemStack)skull);
        OreDictionary.registerOre((String)"itemSkull", (ItemStack)new ItemStack(ModObject.blockEndermanSkull.getBlock()));
        Material.registerOres(ModObject.itemMaterial.getItem());
        MachinePart.registerOres(ModObject.itemMachinePart.getItem());
    }

    public static void addRecipes() {
        for (Alloy alloy : Alloy.values()) {
            Object[] recipe = new Object[]{"iii", "iii", "iii", Character.valueOf('i'), alloy.getOreIngot()};
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(alloy.getStackBlock(), recipe));
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(alloy.getStackIngot(9), new Object[]{alloy.getOreBlock()}));
        }
        for (Alloy alloy : EnumDyeColor.values()) {
            for (FusedQuartzType type : FusedQuartzType.values()) {
                if (alloy == EnumDyeColor.WHITE) {
                    GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ModObject.blockFusedQuartz.getBlock(), 8, type.ordinal()), new Object[]{"GGG", "CGG", "GGG", Character.valueOf('G'), type.getUnlocalisedName(), Character.valueOf('C'), new ItemStack(Items.field_151100_aR, 1, alloy.func_176767_b())}));
                    continue;
                }
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(type.getBlock(), 8, alloy.func_176765_a()), new Object[]{"GGG", "CGG", "GGG", Character.valueOf('G'), new ItemStack(ModObject.blockFusedQuartz.getBlock(), 8, type.ordinal()), Character.valueOf('C'), new ItemStack(Items.field_151100_aR, 1, alloy.func_176767_b())}));
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(type.getBlock(), 8, alloy.func_176765_a()), new Object[]{"GGG", "CGG", "GGG", Character.valueOf('G'), type.getUnlocalisedName(), Character.valueOf('C'), new ItemStack(Items.field_151100_aR, 1, alloy.func_176767_b())}));
            }
        }
        GameRegistry.addRecipe((IRecipe)new NutritiousStickRecipe());
    }
}

