/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.tank;

import crazypants.enderio.fluid.SmartTank;
import crazypants.enderio.machine.ItemTankHelper;
import crazypants.enderio.machine.MachineRenderMapper;
import crazypants.enderio.render.IBlockStateWrapper;
import crazypants.enderio.render.ICacheKey;
import crazypants.enderio.render.IRenderMapper;
import crazypants.enderio.render.property.EnumRenderMode;
import crazypants.enderio.render.util.HalfBakedQuad;
import crazypants.enderio.render.util.ItemQuadCollector;
import crazypants.enderio.render.util.QuadCollector;
import crazypants.enderio.render.util.TankRenderHelper;
import crazypants.util.NbtValue;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class TankItemRenderMapper
extends MachineRenderMapper
implements IRenderMapper.IItemRenderMapper.IDynamicOverlayMapper,
IRenderMapper.IBlockRenderMapper.IRenderLayerAware {
    public static final TankItemRenderMapper instance = new TankItemRenderMapper();

    private TankItemRenderMapper() {
        super(null);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<IBlockState> mapBlockRender(IBlockStateWrapper state, IBlockAccess world, BlockPos pos, BlockRenderLayer blockLayer, QuadCollector quadCollector) {
        ArrayList<IBlockState> states = new ArrayList<IBlockState>();
        if (blockLayer == BlockRenderLayer.CUTOUT) {
            states.add(state.getState().func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)EnumRenderMode.FRONT)));
        } else if (blockLayer == BlockRenderLayer.TRANSLUCENT) {
            states.add(state.getState().func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)EnumRenderMode.FRONT_ON)));
        }
        return states;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemQuadCollector mapItemDynamicOverlayRender(Block block, ItemStack stack) {
        SmartTank tank;
        HalfBakedQuad.HalfBakedList buffer;
        ItemQuadCollector result = new ItemQuadCollector();
        if (stack.func_77942_o() && (buffer = TankRenderHelper.mkTank(tank = ItemTankHelper.getTank(stack), 0.5, 0.5, 15.5, false)) != null) {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            buffer.bake(quads);
            result.addQuads(null, quads);
        }
        if (!NbtValue.FAKE.hasTag(stack)) {
            result.addBlockState(block.func_176203_a(stack.func_77960_j()).func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)EnumRenderMode.FRONT_ON)), stack, true);
        }
        return result;
    }

    @Override
    public List<Pair<IBlockState, ItemStack>> mapItemRender(Block block, ItemStack stack, ItemQuadCollector itemQuadCollector) {
        if (!NbtValue.FAKE.hasTag(stack)) {
            return super.mapItemRender(block, stack, itemQuadCollector);
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public ICacheKey getCacheKey(@Nonnull Block block, @Nonnull ItemStack stack, @Nonnull ICacheKey cacheKey) {
        if (NbtValue.FAKE.hasTag(stack)) {
            cacheKey.addCacheKey(2146898743);
        }
        return cacheKey;
    }
}

