/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine;

import com.enderio.core.common.vecmath.VecmathUtil;
import crazypants.enderio.ModObject;
import crazypants.enderio.capacitor.CapacitorHelper;
import crazypants.enderio.capacitor.CapacitorKey;
import crazypants.enderio.capacitor.CapacitorKeyType;
import crazypants.enderio.capacitor.DefaultCapacitorData;
import crazypants.enderio.capacitor.DefaultCapacitorKey;
import crazypants.enderio.capacitor.ICapacitorData;
import crazypants.enderio.capacitor.ICapacitorKey;
import crazypants.enderio.capacitor.Scaler;
import crazypants.enderio.machine.AbstractInventoryMachineEntity;
import crazypants.enderio.machine.PacketPowerStorage;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.power.IInternalPoweredTile;
import crazypants.util.NbtValue;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;

@Storable
public abstract class AbstractPoweredMachineEntity
extends AbstractInventoryMachineEntity
implements IInternalPoweredTile {
    protected ICapacitorData capacitorData = DefaultCapacitorData.BASIC_CAPACITOR;
    protected final ICapacitorKey maxEnergyRecieved;
    protected final ICapacitorKey maxEnergyStored;
    protected final ICapacitorKey maxEnergyUsed;
    @Store(value={Store.StoreFor.SAVE, Store.StoreFor.CLIENT})
    private int storedEnergyRF;
    protected float lastSyncPowerStored = -1.0f;

    @Deprecated
    protected AbstractPoweredMachineEntity(SlotDefinition slotDefinition) {
        this(slotDefinition, null);
    }

    protected AbstractPoweredMachineEntity(SlotDefinition slotDefinition, ModObject modObject) {
        super(slotDefinition);
        if (modObject == null) {
            this.maxEnergyRecieved = CapacitorKey.LEGACY_ENERGY_INTAKE;
            this.maxEnergyStored = CapacitorKey.LEGACY_ENERGY_BUFFER;
            this.maxEnergyUsed = CapacitorKey.LEGACY_ENERGY_USE;
        } else {
            this.maxEnergyRecieved = new DefaultCapacitorKey(modObject, CapacitorKeyType.ENERGY_INTAKE, Scaler.Factory.POWER, 80);
            this.maxEnergyStored = new DefaultCapacitorKey(modObject, CapacitorKeyType.ENERGY_BUFFER, Scaler.Factory.POWER, 100000);
            this.maxEnergyUsed = new DefaultCapacitorKey(modObject, CapacitorKeyType.ENERGY_USE, Scaler.Factory.POWER, 20);
        }
    }

    public AbstractPoweredMachineEntity(SlotDefinition slotDefinition, ICapacitorKey maxEnergyRecieved, ICapacitorKey maxEnergyStored, ICapacitorKey maxEnergyUsed) {
        super(slotDefinition);
        this.maxEnergyRecieved = maxEnergyRecieved;
        this.maxEnergyStored = maxEnergyStored;
        this.maxEnergyUsed = maxEnergyUsed;
    }

    public void init() {
        super.init();
        this.onCapacitorDataChange();
    }

    @Override
    public void doUpdate() {
        boolean powerChanged;
        super.doUpdate();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean bl = powerChanged = this.lastSyncPowerStored != (float)this.storedEnergyRF && this.shouldDoWorkThisTick(5);
        if (powerChanged) {
            this.lastSyncPowerStored = this.storedEnergyRF;
            PacketHandler.sendToAllAround(new PacketPowerStorage(this), (TileEntity)this);
        }
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return !this.isSideDisabled(from);
    }

    public int getMaxEnergyStored() {
        return this.getMaxEnergyStored(null);
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.maxEnergyStored == null ? 0 : this.maxEnergyStored.get(this.capacitorData);
    }

    @Override
    public void setEnergyStored(int stored) {
        this.storedEnergyRF = MathHelper.func_76125_a((int)stored, (int)0, (int)this.getMaxEnergyStored());
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.storedEnergyRF;
    }

    public int getEnergyStored() {
        return this.getEnergyStored(null);
    }

    @Override
    public boolean displayPower() {
        return true;
    }

    public boolean hasPower() {
        return this.storedEnergyRF > 0;
    }

    public ICapacitorData getCapacitorData() {
        return this.capacitorData;
    }

    public int getEnergyStoredScaled(int scale) {
        int maxEnergyStored2 = this.getMaxEnergyStored();
        return maxEnergyStored2 == 0 ? 0 : VecmathUtil.clamp((int)Math.round((float)scale * ((float)this.storedEnergyRF / (float)maxEnergyStored2)), (int)0, (int)scale);
    }

    public void onCapacitorDataChange() {
        this.setEnergyStored(this.getEnergyStored(null));
        this.forceClientUpdate.set();
    }

    public int getPowerUsePerTick() {
        return this.maxEnergyUsed == null ? 0 : this.maxEnergyUsed.get(this.capacitorData);
    }

    @Override
    public void func_70299_a(int slot, @Nullable ItemStack contents) {
        super.func_70299_a(slot, contents);
        if (this.slotDefinition.isUpgradeSlot(slot)) {
            this.updateCapacitorFromSlot();
        }
    }

    @Override
    public ItemStack func_70298_a(int fromSlot, int amount) {
        ItemStack res = super.func_70298_a(fromSlot, amount);
        if (this.slotDefinition.isUpgradeSlot(fromSlot)) {
            this.updateCapacitorFromSlot();
        }
        return res;
    }

    private void updateCapacitorFromSlot() {
        if (this.slotDefinition.getNumUpgradeSlots() <= 0) {
            this.capacitorData = DefaultCapacitorData.BASIC_CAPACITOR;
        } else {
            this.capacitorData = CapacitorHelper.getCapacitorDataFromItemStack(this.inventory[this.slotDefinition.minUpgradeSlot]);
            if (this.capacitorData == null) {
                this.capacitorData = DefaultCapacitorData.BASIC_CAPACITOR;
            }
        }
        this.onCapacitorDataChange();
    }

    @Override
    public void readCommon(NBTTagCompound nbtRoot) {
        super.readCommon(nbtRoot);
        this.updateCapacitorFromSlot();
    }

    @Override
    public void readFromItemStack(ItemStack stack) {
        NBTTagCompound root;
        super.readFromItemStack(stack);
        if (stack != null && (root = stack.func_77978_p()) != null) {
            int energyStored = root.func_74764_b("storedEnergyRF") ? root.func_74762_e("storedEnergyRF") : NbtValue.ENERGY.getInt(root);
            this.setEnergyStored(energyStored);
        }
    }

    @Override
    public void writeToItemStack(ItemStack stack) {
        if (stack == null) {
            return;
        }
        super.writeToItemStack(stack);
        NBTTagCompound root = stack.func_77978_p();
        if (root == null) {
            root = new NBTTagCompound();
            stack.func_77982_d(root);
        }
        NbtValue.ENERGY.setInt(stack, this.storedEnergyRF);
    }
}

