/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import crazypants.enderio.EnderIO;
import crazypants.enderio.power.IInternalPoweredItem;
import crazypants.util.Prep;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class SetRandomEnergy
extends LootFunction {
    public SetRandomEnergy(LootCondition[] conditionsIn) {
        super(conditionsIn);
    }

    public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
        IEnergyStorage capability;
        if (Prep.isValid(stack) && stack.func_77973_b() instanceof IInternalPoweredItem) {
            IInternalPoweredItem item = (IInternalPoweredItem)stack.func_77973_b();
            int maxEnergyStored = item.getMaxEnergyStored(stack);
            int realEnergy = (int)((double)maxEnergyStored * 0.1 + (double)maxEnergyStored * 0.5 * (double)rand.nextFloat());
            item.setEnergyStored(stack, realEnergy);
        } else if (Prep.isValid(stack) && stack.hasCapability(CapabilityEnergy.ENERGY, null) && (capability = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)) != null) {
            int maxEnergyStored = capability.getMaxEnergyStored();
            for (int realEnergy = (int)((double)maxEnergyStored * 0.1 + (double)maxEnergyStored * 0.5 * (double)rand.nextFloat()); realEnergy > 0; realEnergy -= Math.max(1, capability.receiveEnergy(realEnergy, false))) {
            }
        }
        return stack;
    }

    public static class Serializer
    extends LootFunction.Serializer<SetRandomEnergy> {
        protected Serializer() {
            super(new ResourceLocation(EnderIO.DOMAIN, "set_random_energy"), SetRandomEnergy.class);
        }

        public void serialize(JsonObject object, SetRandomEnergy functionClazz, JsonSerializationContext serializationContext) {
        }

        public SetRandomEnergy deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootCondition[] conditionsIn) {
            return new SetRandomEnergy(conditionsIn);
        }
    }
}

