/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.enderio.core.common.transform.EnderCoreMethods;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.PowerBarOverlayRenderHelper;
import crazypants.enderio.power.PowerDisplayUtil;
import crazypants.util.NbtValue;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemColdFireIgniter
extends Item
implements IAdvancedTooltipProvider,
EnderCoreMethods.IOverlayRenderAware,
IFluidContainerItem {
    private static final int FLUID_CAPACITY = 1000;

    public static ItemColdFireIgniter create() {
        ItemColdFireIgniter result = new ItemColdFireIgniter();
        result.init();
        return result;
    }

    protected ItemColdFireIgniter() {
        this.func_77637_a(EnderIOTab.tabEnderIOItems);
        this.func_77655_b(ModObject.itemColdFireIgniter.getUnlocalisedName());
        this.setRegistryName(ModObject.itemColdFireIgniter.getUnlocalisedName());
        this.func_77656_e(0);
        this.func_77625_d(1);
    }

    protected void init() {
        GameRegistry.register((IForgeRegistryEntry)this);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!player.func_175151_a(pos = pos.func_177972_a(side), side, stack)) {
            return EnumActionResult.FAIL;
        }
        if (world.func_175623_d(pos)) {
            if (Config.coldFireIgniterMbPerUse > 0 && !this.drain(stack, Config.coldFireIgniterMbPerUse)) {
                Fluid fluid = this.getFluidType(stack);
                String fluidname = fluid.getLocalizedName(new FluidStack(fluid, 1));
                player.func_145747_a((ITextComponent)new TextComponentString(EnderIO.lang.localize("coldfireigniter.chat.outoffluid").replace("{FLUIDNAME}", fluidname)));
            } else {
                world.func_184133_a(player, pos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, field_77697_d.nextFloat() * 0.4f + 0.8f);
                world.func_180501_a(pos, ModObject.blockColdFire.getBlock().func_176223_P(), 11);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    @Nonnull
    public Fluid getFluidType(ItemStack container) {
        return FluidRegistry.getFluid((String)Config.coldFireIgniterFluidType);
    }

    public FluidStack getFluid(ItemStack container) {
        int amount = NbtValue.FLUIDAMOUNT.getInt(container, 0);
        if (amount > 0) {
            return new FluidStack(this.getFluidType(container), amount);
        }
        return null;
    }

    public int getCapacity(ItemStack container) {
        return 1000;
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (container == null || resource == null || resource.amount <= 0 || resource.getFluid() == null || resource.getFluid() != this.getFluidType(container)) {
            return 0;
        }
        int amount = NbtValue.FLUIDAMOUNT.getInt(container, 0);
        int free = 1000 - amount;
        int toFill = Math.min(resource.amount, free);
        if (toFill > 0 && doFill) {
            NbtValue.FLUIDAMOUNT.setInt(container, amount + toFill);
        }
        return toFill;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        return null;
    }

    private boolean drain(ItemStack container, int toDrain) {
        int amount = NbtValue.FLUIDAMOUNT.getInt(container, 0);
        if (toDrain > amount) {
            return false;
        }
        NbtValue.FLUIDAMOUNT.setInt(container, amount - toDrain);
        return true;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new CapabilityProvider(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer par2EntityPlayer, List<String> list, boolean par4) {
        super.func_77624_a(itemStack, par2EntityPlayer, list, par4);
        list.add(NbtValue.FLUIDAMOUNT.getInt(itemStack, 0) + " " + EnderIO.lang.localize("fluid.millibucket.abr") + " " + PowerDisplayUtil.ofStr() + " " + this.getFluidType(itemStack).getLocalizedName(null));
    }

    public void addCommonEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        SpecialTooltipHandler.addCommonTooltipFromResources(list, (String)this.func_77667_c(itemstack));
    }

    public void addBasicEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        SpecialTooltipHandler.addBasicTooltipFromResources(list, (String)this.func_77667_c(itemstack));
    }

    public void addDetailedEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        SpecialTooltipHandler.addDetailedTooltipFromResources(list, (String)this.func_77667_c(itemstack));
    }

    public void renderItemOverlayIntoGUI(ItemStack stack, int xPosition, int yPosition) {
        PowerBarOverlayRenderHelper.instance_fluid.render(stack, xPosition, yPosition, 0);
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        ItemStack stack = new ItemStack(itemIn);
        subItems.add(stack.func_77946_l());
        NbtValue.FLUIDAMOUNT.setInt(stack, 1000);
        subItems.add(stack);
    }

    private class CapabilityProvider
    implements IFluidHandler,
    ICapabilityProvider {
        protected final ItemStack container;

        private CapabilityProvider(ItemStack container) {
            this.container = container;
        }

        public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
        }

        public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return (T)this;
            }
            return null;
        }

        public IFluidTankProperties[] getTankProperties() {
            return new IFluidTankProperties[]{new IFluidTankProperties(){

                @Nullable
                public FluidStack getContents() {
                    return ItemColdFireIgniter.this.getFluid(CapabilityProvider.this.container);
                }

                public int getCapacity() {
                    return ItemColdFireIgniter.this.getCapacity(CapabilityProvider.this.container);
                }

                public boolean canFill() {
                    return true;
                }

                public boolean canDrain() {
                    return false;
                }

                public boolean canFillFluidType(FluidStack fluidStack) {
                    return fluidStack != null && fluidStack.getFluid() == ItemColdFireIgniter.this.getFluidType(CapabilityProvider.this.container);
                }

                public boolean canDrainFluidType(FluidStack fluidStack) {
                    return false;
                }
            }};
        }

        public int fill(FluidStack resource, boolean doFill) {
            return ItemColdFireIgniter.this.fill(this.container, resource, doFill);
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return null;
        }
    }
}

