/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.packet;

import com.enderio.core.common.BlockEnder;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.TileConduitBundle;
import crazypants.enderio.conduit.packet.AbstractConduitBundlePacket;
import crazypants.enderio.conduit.registry.ConduitRegistry;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class AbstractConduitPacket<T extends IConduit>
extends AbstractConduitBundlePacket {
    private UUID uuid;

    public AbstractConduitPacket() {
    }

    public AbstractConduitPacket(TileEntity tile, T conduit) {
        super(tile);
        this.uuid = ConduitRegistry.get(conduit).getNetworkUUID();
    }

    protected Class<? extends IConduit> getConType() {
        return ConduitRegistry.get(this.uuid).getBaseType();
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeLong(this.uuid.getMostSignificantBits());
        buf.writeLong(this.uuid.getLeastSignificantBits());
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.uuid = new UUID(buf.readLong(), buf.readLong());
    }

    protected T getTileCasted(MessageContext ctx) {
        World world = this.getWorld(ctx);
        if (world == null) {
            return null;
        }
        IConduitBundle te = (IConduitBundle)BlockEnder.getAnyTileEntitySafe((IBlockAccess)world, (BlockPos)this.getPos(), TileConduitBundle.class);
        if (te == null) {
            return null;
        }
        return (T)te.getConduit(this.getConType());
    }
}

