/*
 * Decompiled with CFR 0.152.
 */
package exnihiloadscensio.tiles;

import exnihiloadscensio.capabilities.CapabilityHeatManager;
import exnihiloadscensio.capabilities.ICapabilityHeat;
import exnihiloadscensio.networking.PacketHandler;
import exnihiloadscensio.registries.CrucibleRegistry;
import exnihiloadscensio.registries.HeatRegistry;
import exnihiloadscensio.registries.types.Meltable;
import exnihiloadscensio.texturing.Color;
import exnihiloadscensio.texturing.SpriteColor;
import exnihiloadscensio.tiles.CrucibleItemHandler;
import exnihiloadscensio.util.BlockInfo;
import exnihiloadscensio.util.ItemInfo;
import exnihiloadscensio.util.LogUtil;
import exnihiloadscensio.util.Util;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileCrucible
extends TileEntity
implements ITickable {
    private FluidTank tank = new FluidTank(4000);
    private int solidAmount;
    private ItemInfo currentItem;
    private int ticksSinceLast = 0;
    private CrucibleItemHandler itemHandler;
    private static final int MAX_ITEMS = 4;

    public TileCrucible() {
        this.tank.setCanFill(false);
        this.itemHandler = new CrucibleItemHandler();
        this.itemHandler.setTe(this);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ++this.ticksSinceLast;
        if (this.ticksSinceLast >= 10) {
            this.ticksSinceLast = 0;
            int heatRate = this.getHeatRate();
            if (heatRate <= 0) {
                return;
            }
            if (this.solidAmount <= 0) {
                if (this.itemHandler.getStackInSlot(0) != null) {
                    this.currentItem = new ItemInfo(this.itemHandler.getStackInSlot(0));
                    --this.itemHandler.getStackInSlot((int)0).field_77994_a;
                    if (this.itemHandler.getStackInSlot((int)0).field_77994_a <= 0) {
                        this.itemHandler.setStackInSlot(0, null);
                    }
                    this.solidAmount = CrucibleRegistry.getMeltable(this.currentItem).getAmount();
                } else {
                    if (this.currentItem != null) {
                        this.currentItem = null;
                        PacketHandler.sendNBTUpdate(this);
                    }
                    return;
                }
            }
            if (this.itemHandler.getStackInSlot(0) != null && this.itemHandler.getStackInSlot(0).func_77969_a(this.currentItem.getItemStack())) {
                while (heatRate > this.solidAmount && this.itemHandler.getStackInSlot(0) != null) {
                    this.solidAmount += CrucibleRegistry.getMeltable(this.currentItem).getAmount();
                    --this.itemHandler.getStackInSlot((int)0).field_77994_a;
                    if (this.itemHandler.getStackInSlot((int)0).field_77994_a > 0) continue;
                    this.itemHandler.setStackInSlot(0, null);
                }
            }
            if (heatRate > this.solidAmount) {
                heatRate = this.solidAmount;
            }
            if (heatRate > 0 && this.currentItem != null && CrucibleRegistry.canBeMelted(this.currentItem)) {
                FluidStack toFill = new FluidStack(FluidRegistry.getFluid((String)CrucibleRegistry.getMeltable(this.currentItem).getFluid()), heatRate);
                int filled = this.tank.fillInternal(toFill, true);
                this.solidAmount -= filled;
                if (filled > 0) {
                    PacketHandler.sendNBTUpdate(this);
                }
            }
        }
    }

    public int getHeatRate() {
        BlockPos posBelow = this.field_174879_c.func_177982_a(0, -1, 0);
        IBlockState stateBelow = this.field_145850_b.func_180495_p(posBelow);
        if (stateBelow == null) {
            return 0;
        }
        int heat = HeatRegistry.getHeatAmount(new BlockInfo(stateBelow));
        if (heat != 0) {
            return heat;
        }
        TileEntity tile = this.field_145850_b.func_175625_s(posBelow);
        if (tile != null && tile.hasCapability(CapabilityHeatManager.HEAT_CAPABILITY, EnumFacing.UP)) {
            return ((ICapabilityHeat)tile.getCapability(CapabilityHeatManager.HEAT_CAPABILITY, EnumFacing.UP)).getHeatRate();
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public SpriteColor getSpriteAndColor() {
        double fluidProportion;
        int noItems;
        int n = noItems = this.itemHandler.getStackInSlot(0) == null ? 0 : this.itemHandler.getStackInSlot((int)0).field_77994_a;
        if (noItems == 0 && this.currentItem == null && this.tank.getFluidAmount() == 0) {
            return null;
        }
        FluidStack fluid = this.tank.getFluid();
        if (noItems == 0 && this.currentItem == null) {
            return new SpriteColor(Util.getTextureFromFluidStack(fluid), new Color(fluid.getFluid().getColor(), false));
        }
        double solidProportion = (double)noItems / 4.0;
        if (this.currentItem != null) {
            Meltable meltable = CrucibleRegistry.getMeltable(this.currentItem);
            if (meltable != null) {
                solidProportion += (double)this.solidAmount / (double)(4 * meltable.getAmount());
            } else {
                LogUtil.throwing(new NullPointerException("Meltable is null! Item is " + this.currentItem.getItem().func_77658_a()));
            }
        }
        if ((fluidProportion = (double)this.tank.getFluidAmount() / (double)this.tank.getCapacity()) > solidProportion) {
            if (fluid == null || fluid.getFluid() == null) {
                return null;
            }
            return new SpriteColor(Util.getTextureFromFluidStack(fluid), new Color(fluid.getFluid().getColor(), false));
        }
        IBlockState block = null;
        Color color = Util.whiteColor;
        if (this.currentItem != null) {
            Meltable meltable = CrucibleRegistry.getMeltable(this.currentItem);
            BlockInfo override = meltable.getTextureOverride();
            if (override == null) {
                if (Block.func_149634_a((Item)this.currentItem.getItem()) != null) {
                    block = Block.func_149634_a((Item)this.currentItem.getItem()).func_176203_a(this.currentItem.getMeta());
                }
            } else {
                block = override.getBlockState();
            }
            if (block != null) {
                color = new Color(Minecraft.func_71410_x().func_184125_al().func_186724_a(block, (IBlockAccess)this.field_145850_b, this.field_174879_c, 0), true);
            }
        }
        return new SpriteColor(Util.getTextureFromBlockState(block), color);
    }

    @SideOnly(value=Side.CLIENT)
    public float getFilledAmount() {
        Meltable meltable;
        int noItems;
        int n = noItems = this.itemHandler.getStackInSlot(0) == null ? 0 : this.itemHandler.getStackInSlot((int)0).field_77994_a;
        if (noItems == 0 && this.currentItem == null && this.tank.getFluidAmount() == 0) {
            return 0.0f;
        }
        float fluidProportion = (float)this.tank.getFluidAmount() / (float)this.tank.getCapacity();
        if (noItems == 0 && this.currentItem == null) {
            return fluidProportion;
        }
        float solidProportion = (float)noItems / 4.0f;
        if (this.currentItem != null && (meltable = CrucibleRegistry.getMeltable(this.currentItem)) != null) {
            solidProportion = (float)((double)solidProportion + (double)this.solidAmount / (double)(4 * meltable.getAmount()));
        }
        return solidProportion > fluidProportion ? solidProportion : fluidProportion;
    }

    public boolean onBlockActivated(ItemStack stack, EntityPlayer player) {
        if (stack == null) {
            return false;
        }
        if (stack != null && stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
            boolean result = FluidUtil.interactWithFluidHandler((ItemStack)stack, (IFluidHandler)this.tank, (EntityPlayer)player);
            if (result) {
                PacketHandler.sendNBTUpdate(this);
            }
            return true;
        }
        ItemStack addStack = stack.func_77946_l();
        addStack.field_77994_a = 1;
        ItemStack insertStack = this.itemHandler.insertItem(0, addStack, true);
        if (!ItemStack.func_77989_b((ItemStack)addStack, (ItemStack)insertStack)) {
            this.itemHandler.insertItem(0, addStack, false);
            --stack.field_77994_a;
            PacketHandler.sendNBTUpdate(this);
            return true;
        }
        return true;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            this.itemHandler.setTe(this);
            return (T)((Object)this.itemHandler);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tank;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        if (this.currentItem != null) {
            NBTTagCompound currentItemTag = this.currentItem.writeToNBT(new NBTTagCompound());
            tag.func_74782_a("currentItem", (NBTBase)currentItemTag);
        }
        tag.func_74768_a("solidAmount", this.solidAmount);
        NBTTagCompound itemHandlerTag = this.itemHandler.serializeNBT();
        tag.func_74782_a("itemHandler", (NBTBase)itemHandlerTag);
        NBTTagCompound tankTag = this.tank.writeToNBT(new NBTTagCompound());
        tag.func_74782_a("tank", (NBTBase)tankTag);
        return super.func_189515_b(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        this.currentItem = tag.func_74764_b("currentItem") ? ItemInfo.readFromNBT(tag.func_74775_l("currentItem")) : null;
        this.solidAmount = tag.func_74762_e("solidAmount");
        if (tag.func_74764_b("itemHandler")) {
            this.itemHandler.deserializeNBT((NBTTagCompound)tag.func_74781_a("itemHandler"));
        }
        if (tag.func_74764_b("tank")) {
            this.tank.readFromNBT((NBTTagCompound)tag.func_74781_a("tank"));
        }
        super.func_145839_a(tag);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        this.func_145839_a(tag);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = this.func_189515_b(new NBTTagCompound());
        return tag;
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public int getSolidAmount() {
        return this.solidAmount;
    }

    public ItemInfo getCurrentItem() {
        return this.currentItem;
    }

    public CrucibleItemHandler getItemHandler() {
        return this.itemHandler;
    }
}

