/*
 * Decompiled with CFR 0.152.
 */
package exnihiloadscensio.blocks;

import exnihiloadscensio.compatibility.theoneprobe.ITOPInfoProvider;
import exnihiloadscensio.items.ItemBlockMeta;
import exnihiloadscensio.registries.CrucibleRegistry;
import exnihiloadscensio.tiles.TileCrucible;
import java.util.List;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCrucible
extends Block
implements ITOPInfoProvider {
    public static final PropertyBool FIRED = PropertyBool.func_177716_a((String)"fired");

    public BlockCrucible() {
        super(Material.field_151576_e);
        String name = "blockCrucible";
        this.func_149663_c(name);
        this.setRegistryName(name);
        GameRegistry.register((IForgeRegistryEntry)this);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlockMeta(this).setRegistryName(name));
        this.func_149711_c(2.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FIRED, (Comparable)Boolean.valueOf(false)));
    }

    public TileEntity createTileEntity(World worldIn, IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)FIRED)).booleanValue()) {
            return new TileCrucible();
        }
        return null;
    }

    public boolean hasTileEntity(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)FIRED);
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FIRED});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FIRED, (Comparable)Boolean.valueOf(meta != 0));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)FIRED) != false ? 1 : 0;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        list.add(new ItemStack(itemIn, 1, 0));
        list.add(new ItemStack(itemIn, 1, 1));
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, this.func_176201_c(world.func_180495_p(pos)));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileCrucible te = (TileCrucible)world.func_175625_s(pos);
        if (te != null) {
            return te.onBlockActivated(heldItem, player);
        }
        return true;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)1, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileCrucible crucible = (TileCrucible)world.func_175625_s(data.getPos());
        if (crucible == null) {
            return;
        }
        ItemStack solid = crucible.getCurrentItem() == null ? null : crucible.getCurrentItem().getItemStack();
        FluidStack liquid = crucible.getTank().getFluid();
        String solidName = solid == null ? "None" : solid.func_82833_r();
        String liquidName = liquid == null ? "None" : liquid.getLocalizedName();
        int solidAmount = Math.max(0, crucible.getSolidAmount());
        ItemStack toMelt = crucible.getItemHandler().getStackInSlot(0);
        if (toMelt != null) {
            solidAmount += CrucibleRegistry.getMeltable(toMelt).getAmount() * toMelt.field_77994_a;
        }
        probeInfo.text(String.format("Solid (%s): %d", solidName, solidAmount));
        probeInfo.text(String.format("Liquid (%s): %d", liquidName, crucible.getTank().getFluidAmount()));
        probeInfo.text("Rate: " + crucible.getHeatRate() + "x");
    }
}

